% *************************************************************************
% 
%                      iGem Modelling - 2018
%                     Delft University of Technology
% 
% *************************************************************************
% 
%               Title
% 
%                    File: Mesh Density Analysis Graphs
% 
%              
% *************************************************************************
clear all
close all
format long

%Results from Analysis using main model
Mesh_Size = [10; 20; 30; 50; 100; 200];
Run_Time = [3.564899; 7.300073; 16.036469; 34.843051; 149.940009; 886.021478]/60;
Percent_Diff_SSModel = [0.709601; 0.622143; 0.592705; 0.569653; 0.551037; 0.536057];
Percent_Diff_Lit = [1.748602; 1.662059; 1.632929; 1.610118; 1.591697; 1.576874]



figure(1); 
set(gcf, 'Position', [500, 200, 800, 700])
set(gcf,'color','w'); 
subplot( 3,1,1); hold on;
plot(Mesh_Size, Percent_Diff_SSModel, '-or', 'LineWidth',2)
set(gca,'fontsize',14);
xlabel( 'Mesh Density' ); ylabel( 'Error (%)' );

subplot(3,1,2); hold on;
plot(Run_Time, Percent_Diff_SSModel, '-or', 'LineWidth',2)
set(gca,'fontsize',14);
xlabel( 'Run Time (min)' ); ylabel( 'Error (%)' );

subplot(3,1,3);
plot(Mesh_Size, Run_Time, '-or', 'LineWidth',2)
set(gca,'fontsize',14);
xlabel( 'Mesh Density' ); ylabel( 'Run Time (min)' );





